import { type OptionValues } from 'commander';
import type { RepomixOutputStyle } from '../config/configSchema.js';
export interface CliOptions extends OptionValues {
    version?: boolean;
    output?: string;
    include?: string;
    ignore?: string;
    config?: string;
    copy?: boolean;
    verbose?: boolean;
    topFilesLen?: number;
    outputShowLineNumbers?: boolean;
    style?: RepomixOutputStyle;
    init?: boolean;
    global?: boolean;
    remote?: string;
    remoteBranch?: string;
    securityCheck?: boolean;
    fileSummary?: boolean;
    directoryStructure?: boolean;
    removeComments?: boolean;
    removeEmptyLines?: boolean;
    tokenCountEncoding?: string;
}
export declare const run: () => Promise<void>;
export declare const executeAction: (directory: string, cwd: string, options: CliOptions) => Promise<void>;
//# sourceMappingURL=cliRun.d.ts.map